//
//  MCSourceListAbstractPaneView.h
//  MCApplication
//
//  Created by Michael Clark on Tue Jul 06 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

#import <MCFoundation/MCSourceList.h>

@interface MCSourceListAbstractPaneView : NSView {
    NSString    *_identifier;
	NSString*    _fetchKey;
    BOOL         _configured;
	
	BOOL         _ignoreSelectionChanges;
}

// Returns the key to be used to save/read setting information
- (NSString*)userDefaultsKey;

// Accessors

/*!
@method     identifier
 @abstract   The identifier used to represent the source list pane view
 @discussion Each pane view type has a unique identifier
 */
- (NSString *)identifier;

    /*!
    @method     setIdentifier:
     @abstract   Tells the pane view its unique identifier
     @discussion Sets the unique identifier on the pane view.  Every time you set the identifier on a pane view, and the identifier is different from the currently set identifier it will reconfigure itself.
     @param      anIdentifier The unique identifier string representing the configuration information for this instance
     */
- (void)setIdentifier:(NSString *)anIdentifier;

// Forces the selected sourcelists to refresh they data
- (void)refreshSelectedSourceLists;

// Forces the view to refresh the sourcelists that are being displayed
- (void)refreshSourceListsDisplay;

// Refreshes the sourcelists that are being displayed, and calculates which sourcelist to select in place of the removed ones
//   Returns the newly selected sourcelist
- (id <MCSourceList>)refreshSourceListsDisplayForDeletedSourceLists: (NSArray*)deletedSourceLists;

// Selects the passed in source lists
- (void)selectSourceLists: (NSArray*)sourceLists;
- (NSArray*)selectedSourceLists;



- (void)ignoreSelectionChanges;
- (void)observeSelectionChanges;

// Used as the value to unique on when fetching source lists from the source list manager
- (NSString *)fetchKey;
- (void)setFetchKey:(NSString *)aFetchKey;

@end
